  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Apr 13 12:09:38 2009
   *  Last modified   :  %modify_time%
   *
   *  \version SST_SEP_ATP_MM.c#1:csrc:1
   *  \author taniam
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/************* Include Files ***********************************/
#include "SST_SEP_TST.h"
#include "CRYS_SST.h" 
#include "SEP_ATP_UTIL_funcs.h"
#include "SST_SEP_ATP_MM.h"

extern  TST_ATP_MMDataOpTestDataStruct*        TST_ATP_MMDataOpTestData;

/*****************************************************************************
* Function Name:
*  SEPQA_SST_MM_1
*
* Inputs:
*  None
*
* Outputs:
*  DxError_t - Function error return
*
* Description:
*    Test the mode management set and get APIs and authenticator with mode
*
* Algorithm:
*
*    1. Call SST_MMGet and verify the SST is in privilege mode.
*    2. Call SST_SessionCreate.
*    3. Call SST_TransactionStart. 
*    4. Call SST_MMPrivAuthCreate to Create a privileged mode authenticator
*    5. Call SST_AuthenticatorAESSharedSecretCreate.
*    6. Call SST_AuthenticatorPasswordCreate - this Authenticator will be in user mode  - cleaner-authenticator.
*    7. Call SST_MMAuthSet and set to Privileged.
*    8. Call SST_DataInsert with the priv-authenticator as initial control authenticator.
*    9. Call SST_TransactionEnd.
*    10. Call SST_MMPriAuthOpen to open the priv-authenticator on the session.
*    11. Call SST_TransactionStart 
*    12 .Call SST_AuthenticatorBind with the data and aes-authenticator.
*    13. Call SST_AuthenticatorBind with the data and cleaner-authenticator.
*    14. Call SST_DataRead and verify the data is correct. 
*    15. Call SST_AuthenticationClose (priv).
*    16. Call SST_DataRead  FAIL
*    17. Call SST_TransactionEnd.
*    18. Call SST_MMSet and set the system to user mode.
*    19. Call SST_MMPrivAuthOpen to the priv-authenticator, verify the operation failed.
*    20. Call SST_AuthenticatorChallengeGet
*    21. Call CRYS_AES and Encrypt the data with the key fro the AES authenticator
*    22. Call SST_AuthenticationOpen to the aes-authenticator, verify the operation failed.
*    23. Call SST_SessionDelete.
*******************************************************************************/     
DxError_t SEPQA_SST_MM_1 ( void )
{
    DxChar             * TestName = "ATP test SST mode management";
    DxChar             * pass = "1234";
    SSTSessionId_t     TST_SessionId;
    SSTTxnId_t         TST_TransactionId;
    SSTMode_t          TST_SSTState;
    SSTHandle_t        TST_AESAuthHandle,TST_PrivAuthHandle,TST_DataHandle,TST_InitialCtrlAuth, TST_CleanAuthHandle;
    SSTDataType_t      TST_DataType = TST_DATA_OBJECT;
    SSTChallengeId_t   TST_ChallengeId;
    DxError_t       TST_Status = DX_FAILURE;



    TST_InitialCtrlAuth.objId = SST_CLOSE_AUTH_HANDLE;
    TST_InitialCtrlAuth.objDigest = 0;
    
    ATP_LOG_TST_PRINT((SST_TST_MSG," ****************************************************** \n"));
    ATP_LOG_TST_PRINT((SST_TST_MSG," ***************** SST_TST_ATP_MM Tests *************** \n"));
    ATP_LOG_TST_PRINT((SST_TST_MSG," ****************************************************** \n \n"));



    /*1. Call SST_MMGet and verify the SST is in privilege mode.*/
    TST_Status = SST_MMGet(&TST_SSTState);
    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_MMGet",
                               TestName,
                               TestName);


    if(TST_SSTState != SST_MODE_PRIVILEGED)
      TST_Status  = TESTFAIL;
    else
      TST_Status  = TESTPASS;




     /* 2.Call SST_SessionCreate */
    /*---------------------------*/
      TST_Status = SST_SessionCreate(&TST_SessionId);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_SessionCreate",
                   TestName,
                   TestName);


    /*3. Call SST_TransactionStart*/
    /*----------------------------*/
    TST_Status = SST_TransactionStart(&TST_TransactionId);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionStart",
                               TestName,
                               TestName);


    /*4. Call SST_MMPriAuthCreate to Create a privileged mode authenticator*/
    TST_Status = SST_MMPrivAuthCreate(TST_TransactionId,
                                      TST_SessionId,
                                      &TST_PrivAuthHandle,
                                      TST_Workspace,
                                      TST_WorkspaceSizeInBytes);

    TST_ATP_MMDataOpTestData[0].TST_PrivAuthHandle= TST_PrivAuthHandle;

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_MMPrivAuthCreate",
                               TestName,
                               TestName);


    TST_AESAuthHandle.objId = SST_HANDLE_RANDOM_GENERATE;

    /* 5.Call SST_AuthenticatorAESSharedSecretCreate*/
    TST_Status = SST_AuthenticatorAESSharedSecretCreate(TST_TransactionId,
                                                        TST_ATP_MMDataOpTestData[0].TST_AesKey,
                                                        SST_KEY_TYPE_AES_128_BIT,
                                                        &TST_AESAuthHandle,
                                                        TST_Workspace,
                                                        TST_WorkspaceSizeInBytes);
    TST_ATP_MMDataOpTestData[0].TST_AESAuthHandle = TST_AESAuthHandle;

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticatorAESSharedSecretCreate",
                               TestName,
                               TestName);
 

    TST_CleanAuthHandle.objId = SST_HANDLE_RANDOM_GENERATE;

   /* 6.Call SST_AuthenticatorPasswordCreate - this Authenticator will be in user mode - cleaner-authenticator.*/
   TST_Status = SST_AuthenticatorPasswordCreate(TST_TransactionId,
                                                TST_SessionId,
                                                pass,
                                                sizeof(pass),
                                                1,
                                                TST_InitialCtrlAuth,
                                                &TST_CleanAuthHandle,
                                                TST_Workspace,
                                                TST_WorkspaceSizeInBytes);


    TST_ATP_MMDataOpTestData[0].TST_CleanAuthHandle = TST_CleanAuthHandle;

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticatorPasswordCreate",
                               TestName,
                               TestName);


    /*7. Call SST_MMAuthSet and set to Privileged.*/
    TST_Status = SST_MMAuthSet(TST_TransactionId,  
                               TST_AESAuthHandle,
                               SST_MODE_PRIVILEGED,
                               TST_Workspace,
                               TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_MMAuthSet",
                               TestName,
                               TestName);

    /* 8. Call SST_DataInsert with the priv-authenticator as initial control authenticator. */
    TST_Status = SST_DataInsert(TST_TransactionId,
                                TST_SessionId, 
                                TST_PrivAuthHandle,
                                TST_ATP_MMDataOpTestData[0].TST_Data,
                                TST_ATP_MMDataOpTestData[0].TST_DataSize,
                                DX_TRUE,
                                TST_DataType,
                                &TST_DataHandle,
                                TST_Workspace,
                                TST_WorkspaceSizeInBytes);

    TST_ATP_MMDataOpTestData[0].TST_DataHandle = TST_DataHandle;

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataInsert",
                               TestName,
                               TestName);

    /*9. Call SST_TransactionEnd*/
    TST_Status = SST_TransactionEnd(TST_TransactionId,DX_TRUE,TST_Workspace,TST_WorkspaceSizeInBytes);
    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionEnd",
                               TestName,
                               TestName);


    /*10 Call SST_MMPriAuthOpen to open the priv-authenticator on the session*/
    TST_Status = SST_MMPrivAuthOpen(TST_SessionId,TST_PrivAuthHandle,TST_Workspace,TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_MMPriAuthOpen",
                               TestName,
                               TestName);


    /*11. Call SST_TransactionStart*/
    TST_Status = SST_TransactionStart(&TST_TransactionId);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionStart",
                               TestName,
                               TestName);


    /*12  Call SST_AuthenticatorBind with the data and aes-authenticator.*/
    TST_Status = SST_AuthenticatorBind(TST_TransactionId,
                                       TST_SessionId,
                                       TST_DataHandle,
                                       TST_AESAuthHandle,
                                       SST_PERMISSION_READ_ONLY,
                                       TST_Workspace,
                                       TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticatorBind",
                               TestName,
                               TestName);

    /*13. Call SST_AuthenticatorBind with the data and cleaner-authenticator.*/
    TST_Status = SST_AuthenticatorBind(TST_TransactionId,
                                       TST_SessionId,
                                       TST_DataHandle,
                                       TST_CleanAuthHandle,
                                       SST_PERMISSION_CONTROL,
                                       TST_Workspace,
                                       TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticatorBind",
                               TestName,
                               TestName);

    /*14. Call SST_DataRead and verify the data is correct.*/
    TST_Status = SST_DataRead(TST_SessionId,
                              TST_DataHandle,
                              0,
                              TST_ATP_MMDataOpTestData[0].TST_OutputData,
                              &TST_ATP_MMDataOpTestData[0].TST_DataSize,
                              TST_Workspace,
                              TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataRead",
                               TestName,
                               TestName);


    /* Compare the retrieved data to the original */
    if(!DX_VOS_MemCmp(TST_ATP_MMDataOpTestData[0].TST_Data,
                      TST_ATP_MMDataOpTestData[0].TST_OutputData,
                      TST_ATP_MMDataOpTestData[0].TST_DataSize))
      TST_Status = TESTPASS; /*Data Buffers are the same*/
    else
      TST_Status = TESTFAIL; /*Data Buffers are different*/

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"DX_VOS_MemCmp",
                               TestName,
                               TestName);
    

    /*15. Call SST_AuthenticationClose (priv).*/
    TST_Status = SST_AuthenticationClose(TST_SessionId,TST_PrivAuthHandle);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticationClose priv",
                               TestName,
                               TestName);

    /*16. Call SST_DataRead  FAIL*/
    TST_Status = SST_DataRead(TST_SessionId,
                              TST_DataHandle,
                              0,
                              TST_ATP_MMDataOpTestData[0].TST_OutputData,
                              &TST_ATP_MMDataOpTestData[0].TST_DataSize,
                              TST_Workspace,
                              TST_WorkspaceSizeInBytes);

    if(TST_Status == SST_RC_ERROR_ACCESS_DENIED)
      TST_Status = TESTPASS;
    else 
      TST_Status = TESTFAIL;

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataRead (FAIL)",
                               TestName,
                               TestName);

    /*17. Call SST_TransactionEnd.*/
    TST_Status = SST_TransactionEnd(TST_TransactionId,DX_TRUE,TST_Workspace,TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionEnd",
                               TestName,
                               TestName);

    /*18. Call SST_MMSystemSet and set the system to user mode.*/
    TST_Status = SST_MMSet(SST_MODE_USER);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_MMSet - SST_STATE_MODE_USER",
                               TestName,
                               TestName);

    /*19. Call SST_MMPrivAuthOpen to the priv-authenticator, verify the operation failed.*/
    TST_Status = SST_MMPrivAuthOpen(TST_SessionId,TST_PrivAuthHandle,TST_Workspace, TST_WorkspaceSizeInBytes);

    if(TST_Status == SST_RC_ERROR_MODE_ILLEGAL)
        TST_Status = TESTPASS;
    else 
        TST_Status = TESTFAIL;

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_MMPrivAuthOpen  (FAIL)",
                               TestName,
                               TestName);
    

    /* 20. Call SST_AuthenticatorChallengeGet*/
    TST_Status = SST_AuthenticatorChallengeGet(TST_ATP_MMDataOpTestData[0].TST_ChallengeBuff,
                                               TST_ATP_MMDataOpTestData[0].TST_ChallengeBuffSize,  
                                               &TST_ChallengeId);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticatorChallengeGet",
                               TestName,
                               TestName);


    /* 21. Call CRYS_AES and Encrypt the data with the key fro the AES authenticator */
    TST_Status = CRYS_AES(DX_NULL,
                          TST_ATP_MMDataOpTestData[0].TST_AesKey,
                          CRYS_AES_Key128BitSize,
                          CRYS_AES_Encrypt,
                          CRYS_AES_ECB_mode,
                          TST_ATP_MMDataOpTestData[0].TST_ChallengeBuff,
                          TST_ATP_MMDataOpTestData[0].TST_ChallengeBuffSize,
                          TST_ATP_MMDataOpTestData[0].TST_EncChallengeBuff);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"CRYS_AES",
                               TestName,
                               TestName);

    /*22. Call SST_AuthenticationOpen to the aes-authenticator, verify the operation failed.*/
    TST_Status = SST_AuthenticationOpen(TST_SessionId,
                                        TST_AESAuthHandle,
                                        TST_ATP_MMDataOpTestData[0].TST_EncChallengeBuff,
                                        TST_ATP_MMDataOpTestData[0].TST_EncChallengeBuffSize,
                                        TST_ChallengeId,
                                        TST_Workspace,
                                        TST_WorkspaceSizeInBytes);

    if(TST_Status == SST_RC_ERROR_MODE_ILLEGAL)
      TST_Status = TESTPASS;
    else 
      TST_Status = TESTFAIL;

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticationOpen  (FAIL)",
                               TestName,
                               TestName);


    /*23. Call SST_SessionDelete.*/
    TST_Status = SST_SessionDelete(TST_SessionId);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_SessionDelete",
                               TestName,
                               TestName);


EXIT_ON_ERROR:  
    return TST_Status;

}


/*****************************************************************************
* Function Name:
*  SEPQA_SST_MM_2
*
* Inputs:
*  None
*
* Outputs:
*  DxError_t - Function error return
*
* Description:
*    Test the mode management set and get APIs and authenticator with mode
*
* Algorithm:
*
*    1.    #ifndef DX_CC5_SEP_PLAT
*         Call SST_MMSet with user mode
*          #endif // PC
*    2. Call SST_MMGet and verify the SST is in user mode.
*    3. Call SST_SessionCreate.
*    4. Call SST_AuthenticationOpen to the cleaner-authenticator.
*    5. Call SST_TransactionStart 
*    6. Call SST_DataDelete to delete the data object.
*    7. Close the cleaner authenticator.
*    8  Call SST_AuthenticatorDelete to all the authenticators
*    9. Call SST_SessionDelete
*    10. Call SST_TransactionEnd
*******************************************************************************/     
DxError_t SEPQA_SST_MM_2 ( void )
{

    DxChar             * TestName = "ATP test SST mode management";
    DxChar             * pass = "1234";
    SSTSessionId_t     TST_SessionId;
    SSTTxnId_t         TST_TransactionId;
    SSTMode_t          TST_SSTState;
    SSTDataType_t      TST_DataType = TST_DATA_OBJECT;
    DxError_t       TST_Status = DX_FAILURE;


    #ifndef DX_CC5_SEP_PLAT
   /*1. Call SST_MMSet with user mode*/
    TST_Status = SST_MMSet(SST_MODE_USER);
   TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_MMSet",
                                          TestName,
                                          TestName);
    #endif


    /*2. Call SST_MMGet and verify the SST is in user mode.*/
    TST_Status = SST_MMGet(&TST_SSTState);
    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_MMGet",
                                           TestName,
                                           TestName);

    if(TST_SSTState == SST_MODE_USER)
      TST_Status = TESTPASS;
    else 
      TST_Status = TESTFAIL;

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"verify the SST is in user mode",
                               TestName,
                               TestName);

    /* 3. Call SST_SessionCreate.*/
    TST_Status = SST_SessionCreate(&TST_SessionId);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_SessionCreate",
                               TestName,
                               TestName);


    /* 4. Call SST_AuthenticationOpen to the cleaner-authenticator.*/
    TST_Status = SST_AuthenticationOpen(TST_SessionId,
                                       TST_ATP_MMDataOpTestData[0].TST_CleanAuthHandle,
                                       pass,
                                       sizeof(pass),
                                       TST_NO_CHALLENGE,
                                       TST_Workspace,
                                       TST_WorkspaceSizeInBytes);


    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticationOpen cleaner-authenticator)",
                               TestName,
                               TestName);
   

    /* 5. Call SST_TransactionStart */
    TST_Status = SST_TransactionStart(&TST_TransactionId);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionStart",
                               TestName,
                               TestName);
    

    /* 6. Call SST_DataDelete to delete the data object.*/
    TST_Status = SST_DataDelete(TST_TransactionId,
                               TST_SessionId,
                               TST_ATP_MMDataOpTestData[0].TST_DataHandle,
                               TST_Workspace,
                               TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataDelete",
                               TestName,
                               TestName);
    

     /*7. Close the cleaner authenticator*/
    TST_Status =  SST_AuthenticationClose(TST_SessionId, TST_ATP_MMDataOpTestData[0].TST_CleanAuthHandle);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticationClose cleaner authenticator",
                               TestName,
                               TestName);


    /* 8. Call SST_AuthenticatorDelete to all the authenticators*/
    TST_Status = SST_AuthenticatorDelete(TST_TransactionId,TST_ATP_MMDataOpTestData[0].TST_AESAuthHandle);
    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticatorDelete AES authenticator",
                               TestName,
                               TestName);
    

    TST_Status = SST_AuthenticatorDelete(TST_TransactionId,TST_ATP_MMDataOpTestData[0].TST_PrivAuthHandle);
    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticatorDelete Priv authenticator",
                               TestName,
                               TestName);
    

    /* 9. Call SST_SessionDelete*/
    TST_Status = SST_SessionDelete(TST_SessionId);
    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_SessionDelete",
                               TestName,
                               TestName);
    
    /* 10. Call SST_TransactionEnd*/ 
    TST_Status = SST_TransactionEnd(TST_TransactionId,DX_TRUE,TST_Workspace,TST_WorkspaceSizeInBytes);
    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionEnd",
                               TestName,
                               TestName);

EXIT_ON_ERROR:  
    return TST_Status;  

}
//#endif
